#ifndef KMNG_ERR_H
#define KMNG_ERR_H
	 
/*! \file KMNG_ERR.h
    \brief This file contains the KMNG errors .
*/
#ifdef __cplusplus
extern "C"
{
#endif

#include "KMNG_base_error.h"
#include "DX_VOS_BaseTypes.h"	 

#define DX_SEP_KMNG_OK									DX_SEP_OK
#define KMNG_LLF_KEY_STRUCT_NULL_ERR					(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x1UL)
#define KMNG_LLF_PSW_BUFF_NULL_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x2UL)
#define KMNG_LLF_KEY_BUFF_NULL_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x3UL)
#define KMNG_LLF_PSW_SIZE_ZERO_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x4UL)
#define KMNG_LLF_KEY_SIZE_ZERO_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x5UL)
#define KMNG_LLF_KEY_GEN_DATA_BUFF_NULL_ERR				(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x6UL)
#define KMNG_LLF_KEY_BUF_SIZE_INSUFFICIENT_ERR			(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x7UL)
#define KMNG_LLF_RING_AES_MAC_VERIFY_ERROR				(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x8UL)
#define KMNG_LLF_SYM_KEY_TYPE_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x9UL)
#define KMNG_LLF_ASYM_KEY_TYPE_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0xAUL)
#define KMNG_LLF_HASH_PASSWORD_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0xBUL)
#define KMNG_LLF_KEY_RING_TYPE_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0xCUL)
#define KMNG_LLF_KEY_RING_LEN_ERR 						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0xDUL)
#define KMNG_LLF_IMPORT_SYM_KEY_BUFF_NULL_ERR			(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0xEUL)
#define KMNG_LLF_MODULO_BUFF_NULL_ERR					(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0xFUL)
#define KMNG_LLF_PUB_BUFF_NULL_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x10UL)
#define KMNG_LLF_PRV_BUFF_NULL_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x11UL)
#define KMNG_LLF_MODULO_SIZE_NULL_ERR					(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x12UL)
#define KMNG_LLF_PRV_SIZE_NULL_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x13UL)
#define KMNG_LLF_PUB_SIZE_NULL_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x14UL)
#define KMNG_LLF_CONFIG_BUFF_NULL_ERR					(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x15UL)
#define KMNG_LLF_WRONG_INDEX_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x16UL)
#define KMNG_LLF_UNEXPORTABLE_KEY_ERR					(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x17UL)
#define KMNG_LLF_KEY_LEN_ERR                            (DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x18UL)
#define KMNG_LLF_KEY_TYPE_ERR							(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x19UL)
#define KMNG_LLF_KEY_REST_ERR							(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x1AUL)
#define KMNG_LLF_KEY_USAGE_ERR							(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x1BUL)
#define KMNG_LLF_GEN_BUFF_NULL_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x1CUL)
#define KMNG_LLF_GEN_SIZE_NULL_ERR						(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x1DUL)
#define KMNG_LLF_DH_MODULUS_BUFF_SIZE_INSUFFICIENT_ERR	(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x1EUL)
#define KMNG_LLF_DH_GEN_BUFF_SIZE_INSUFFICIENT_ERR		(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x1FUL)
#define KMNG_LLF_DH_PRIV_BUFF_SIZE_INSUFFICIENT_ERR		(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x20UL)
#define KMNG_LLF_DH_PUB_BUFF_SIZE_INSUFFICIENT_ERR		(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x21UL)
#define KMNG_LLF_DEC_OPER_FOR_PUB_KEY_ERR				(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x22UL)
#define KMNG_LLF_ENC_OPER_FOR_PRIV_KEY_ERR				(DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x23UL)
#define KMNG_LLF_DH_NOT_SUPPORTED_ERR				    (DX_SEP_KMNG_LLF_MODULE_ERROR_BASE + 0x24UL)

#ifdef __cplusplus
}
#endif
#endif /*KMNG_DEFS_H*/

